function RollParameters=RollEstimate01(s,Display)
%	s is a structure array of data segments.
if nargin<2; Display=false; end;
for iSegment=1:length(s);
	dp = diff(s(iSegment).p);
	s(iSegment).n = numel(dp);
	s(iSegment).v = dp*dp';
	s(iSegment).c = dp(2:end)*dp(1:end-1)';
	s(iSegment).nc = s(iSegment).n-1;
end

var = sum([s.v])/sum([s.n]);
acv = sum([s.c])/sum([s.nc]);
if acv<0
	RollParameters.HalfSpread = sqrt(-acv);
else
	RollParameters.HalfSpread = NaN;
end
RollParameters.Variance = var+2*acv;
if RollParameters.Variance>0
	RollParameters.SD = sqrt(RollParameters.Variance);
else
	RollParameters.Variance = NaN;
	RollParameters.SD = NaN;
end
if Display;
	disp(['var: ' num2str(var) ' acv: ' num2str(acv)])
	disp('Moment estimates of Roll parameters:');
	disp(RollParameters);
end;
